const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");

router.post("/setDepartMeeting", (req, res) => {
  if (req.body.kpi === "" || req.body.departName === "") {
    return res.status(404).send({
      message: "Please fill all fields",
    });
  }
  // console.log(req.body);
  let payload = {
    tableName: tableName.setDeaprtmentKpi,
    databaseFields: {
      departName: req.body.departName || "",
      kpi: req.body.kpi || "",
      targetValue: req.body.targetValue || "",
      minimumValue: req.body.minimumValue || "",
      maximumValue: req.body.maximumValue || "",
      isImportant: req.body.isImportant || 0,
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
