const express = require("express");
const pool = require("../../Utils/db");
const router = express.Router();
const response = require("../../GlobalResponse/RESPONSE");
const {
  GlobalSelect,
  GlobalSelectWithWhereClause,
} = require("../../GlobalFunctions/GlobalSelect");
const tableName = require("../../Utils/allTableNames");
const tableNames = require("../../Utils/allTableNames");

router.get("/selectDepartment", (req, res) => {
  payload = {
    tableName: tableName.Departments,
  };
  GlobalSelect(payload, res);
});
router.get("/selectLine", (req, res) => {
  payload = {
    tableName: tableName.lineNames,
  };
  GlobalSelect(payload, res);
});
router.get("/selectProduct", (req, res) => {
  // // console.log("req.body line >>>>>", req.query);
  payload = {
    tableName: tableName.ProductDetails,
    key: "lineName",
    value: req.query.lineName,
    select: "*",
  };
  // // // console.log('payload .....', payload);
  GlobalSelectWithWhereClause(payload, res);
});
router.get("/selectLineAgainstDepartment", (req, res) => {
  // // console.log("req.body liness >>>>>", req.query);
  payload = {
    tableName: tableName.lineNames,
    key: "department",
    value: req.query.department,
    select: "*",
  };
  GlobalSelectWithWhereClause(payload, res);
});
router.get("/selectProductAginstLine", (req, res) => {
  // // console.log("req.body liness >>>>>", req.query);
  payload = {
    tableName: tableName.ProductDetails,
    key: "lineName",
    value: req.query.lineName,
    select: "*",
  };
  GlobalSelectWithWhereClause(payload, res);
});
router.post("/selectLLFeedbackAgainstDepartment", (req, res) => {
  const deptName = req.body.deptName;
  const date = req.body.date;
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `SELECT * from ${tableNames.LLFeedback} where deptName="${deptName}" AND DateSubmission="${date}"`,
        (err, result) => {
          connection.release();
          if (err) {
            // // console.log(err);
            return res.send(response(false, "error while selecting", err));
          } else {
            // // console.log(result);

            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    conosle.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});
router.get("/selectUser", (req, res) => {
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `SELECT DISTINCT submittedBy from ${tableNames.LLFeedback}`,
        (err, result) => {
          connection.release();
          if (err) {
            // // console.log(err);
            return res.send(response(false, "error while selecting", err));
          } else {
            // console.log(result);

            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    conosle.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});
router.post("/selectSubmittedUserData", (req, res) => {
  // // console.log("req.body" , req.body);
  // const { deptName, lineName, userName,submittedDate } = req.body;
  const { deptName, lineName, submittedDate, productName,teamName,siteDetails, shiftDetails } = req.body;
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      let query = productName
        ? `SELECT * from ${tableNames.LLFeedback} where deptName="${deptName}" AND lineName="${lineName}" AND productName="${productName}" AND DateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftName="${shiftDetails}" AND siteName="${siteDetails}"`
        : `SELECT * from ${tableNames.LLFeedback} where deptName="${deptName}" AND lineName="${lineName}" AND DateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftName="${shiftDetails}" AND siteName="${siteDetails}"`;
      connection.query(query, (err, result) => {
        connection.release();
        if (err) {
          // console.log(err);
          return res.send(response(false, "error while selecting", err));
        } else {
          // // console.log("result>>>", result);

          return res.send(response(true, "succesfully selected", result));
        }
      });
    });
  } catch (e) {
    conosle.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// // Select LPT data against username
router.post("/selectDepartMeetingUserData", (req, res) => {
  console.log("req.bodyfrom DepartMeeting" , req.body);
  // const { submittedDate, submittedBy } = req.body;
  const { departName, submittedDate, productName,teamName,siteDetails, shiftDetails } = req.body;

  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      let query = productName
      ? `SELECT * from ${tableNames.departFeedBack} where departName="${departName}" AND   productName="${productName}" AND dateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftDetails="${shiftDetails}" AND siteDetails="${siteDetails}"`
      : `SELECT * from ${tableNames.departFeedBack} where departName="${departName}" AND   dateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftName="${shiftDetails}" AND shiftDetails="${shiftDetails}"`;
   
      connection.query(query, (err, result) => {
          connection.release();
          if (err) {
            return res.send(response(false, "error while selecting", err));
          } else {
            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    conosle.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// API for CL, TOTAL FOUND CL, TOP THREE CL END >>>>>>>>>>>>>

module.exports = router;
